//***************************************************************************
//***************************************************************************
//****																	*****
//****	Befehle ber serielle Schnittstelle fr LCD-Digitalanzeige		*****
//****																	*****
//***************************************************************************
//***************************************************************************


//***************************************************************************
//****									
//****		NAK (Fehler) senden
//****
//***************************************************************************

void SendNAK()
{ SBuff1[0]=0x03;
  SBuff1[1]=SysAdr;
  SBuff1[2]=0xFF;
  SendRSData(3);								// 3 Byte zu senden
}

//***************************************************************************
//****									
//****		CNS (Kommando nicht untersttzt) senden
//****
//***************************************************************************

void SendCNS()
{ SBuff1[0]=0x03;
  SBuff1[1]=SysAdr;
  SBuff1[2]=0xF2;
  SendRSData(3);								// 3 Byte zu senden
}

//***************************************************************************
//****									
//****		ACK (Ausfrung OK) senden
//****
//***************************************************************************

void SendACK()
{ SBuff1[0]=0x03;
  SBuff1[1]=SysAdr;
  SBuff1[2]=0x00;
  SendRSData(3);								// 3 Byte zu senden
}

//***************************************************************************
//****									
//****	Auswertung der Befehle von ser. Schnittstelle
//****	Wird vom Hauptprogramm aufgerufen, wenn in ISR
//****	das Ende eines gltigen Datensatzes (n+1 Byte empfangen n= 1. Byte)
//****	erkannt wurde.
//****
//***************************************************************************

void DatensatzAuswerten()
{ int8 i,z;
  int8 bcc=0;

  _DatenEmpfangen=false;						// Flag zurcksetzen
  GIE=0;

  z=PEbuff1;
  PEBuff1=0;									// Puffer zurcksetzen

 // Checksumme berprfen
  for (i=0; i<z; ++i )
    bcc^=EBuff1[i];

  if ((bcc==EBuff1[z])&&(EBuff1[1]==SysAdr))	// Checksumme und Adresse OK?
  { switch(EBuff1[2])							// Befehlsbyte
    {						

// ResetSystem
    case 'R':									// Daten vom Host 03, ADR, 'R', BCC
	 PosT1=0;
	 Get5311Data(0);							// aktuellen Messwert auslesen
	 MWOffset=AS5311Value;
	 InitPIC();
	 SendACK();
	 break;

// GetAbsolutePosition

	case 'P':									// Daten vom Host 03, ADR, 'P', BCC
	  SBuff1[0]=0x07;
	  SBuff1[1]=SysAdr;
	  SBuff1[2]=Messwert.Bytes.B3;
	  SBuff1[3]=Messwert.Bytes.B2;
	  SBuff1[4]=Messwert.Bytes.B1;
	  SBuff1[5]=Messwert.Bytes.B0;				// aktueller Messwert
	  SBuff1[6]=AS5311Flags;
	  SendRSData(7);
	break;	  

// GetPosition

	case 'p':									// Daten vom Host 03, ADR, 'p', BCC
	  SBuff1[0]=0x05;
	  SBuff1[1]=SysAdr;
	  Get5311Data(0);							// aktuellen Messwert auslesen
	  SBuff1[3]=AS5311Value&0xFF;
	  SBuff1[2]=(AS5311Value>>8);
	  SBuff1[4]=AS5311Flags;
	  SendRSData(5);
	break;	  

// GetMagnitude

	case 'm':									// Daten vom Host 03, ADR, 'm', BCC
	  SBuff1[0]=0x05;
	  SBuff1[1]=SysAdr;
	  Get5311Data(1);							// aktuellen Messwert auslesen
	  SBuff1[3]=AS5311Value&0xFF;
	  SBuff1[2]=AS5311Value>>8;
	  SBuff1[4]=AS5311Flags;
	  SendRSData(5);
	break;	  

// SystemTest
    case 0xF0:									// Daten vom Host 03, ADR, 0xF0, BCC
	 SendACK();
	 break;

// ubekannter Befehl
	default:
	 SendCNS();
	 break;
    }
  }
  else //if ((bcc==EBuff1[z])&&(EBuff1[1]==SysAdr))
  { if ((bcc==EBuff1[z])&&(EBuff1[1]==0xFF))
	{ if(EBuff1[2]=='A')									// Daten vom Host 06, OldADR, 'A', NewADR, 'A', NewADR, BCC
		if((EBuff1[2]==EBuff1[4])&&(EBuff1[3]==EBuff1[5]))
		{ if(EBuff1[3]!=0xFF)								// Adresse 0xFF ausblenden
		  { SysAdr=Ebuff1[3];
			Write_EEPROM(255,Ebuff1[3]);
		  }
		  SendACK();
		}	  
	}
  }
  GIE=1;
}
